<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\KelulusanModel;

class Kelulusan extends BaseController
{
    protected $kelulusanModel;

    public function __construct()
    {
        $this->kelulusanModel = new KelulusanModel();
    }

    // GET /kelulusan
    public function index()
    {
        // ✅ View publik (bukan admin)
        return view('admin/kelulusan/index', [
            'title' => 'Cek Kelulusan',
        ]);
    }

    // POST /kelulusan/cek
    public function cek()
    {
        $nisn      = trim((string) $this->request->getPost('nisn'));
        $tgl_lahir = trim((string) $this->request->getPost('tgl_lahir'));

        // ✅ Validasi sederhana
        if ($nisn === '' || $tgl_lahir === '') {
            return view('admin/kelulusan/cek', [
                'title'     => 'Cek Kelulusan',
                'error'     => 'NISN dan Tanggal Lahir wajib diisi.',
                'nisn'      => $nisn,
                'tgl_lahir' => $tgl_lahir,
            ]);
        }

        // ✅ Cari data
        $row = $this->kelulusanModel
            ->where('nisn', $nisn)
            ->where('tgl_lahir', $tgl_lahir)
            ->first();

        if (!$row) {
            return view('admin/kelulusan/index', [
                'title'     => 'Cek Kelulusan',
                'error'     => 'Data tidak ditemukan. Pastikan NISN dan Tanggal Lahir benar.',
                'nisn'      => $nisn,
                'tgl_lahir' => $tgl_lahir,
            ]);
        }

        // ✅ Cek file PDF SKL berdasarkan NISN
        $pdfFile = 'SKL_' . $nisn . '.pdf';
        $pdfPath = ROOTPATH . 'public/uploads/skl/' . $pdfFile;
        $pdfUrl  = is_file($pdfPath) ? base_url('uploads/skl/' . $pdfFile) : null;

        // ✅ Tampilkan hasil (view publik)
        return view('admin/kelulusan/cek', [
            'title'     => 'Cek Kelulusan',
            'row'       => $row,
            'pdf_url'   => $pdfUrl,
            'nisn'      => $nisn,
            'tgl_lahir' => $tgl_lahir,
            'success'   => 'Data ditemukan.',
        ]);
    }
}
